********************************************************************************
*** When Less is More in Boosting Survey Response Rates replication code file ***
*** Katharine M. Conn, Cecilia Hyunjung Mo, Laura M. Sellers ***
*** Social Science Quarterly, XXXX Volume XX Issue XX ***
*** Direct all correspondence to Katharine M. Conn, Senior Research Scientist, ***
*** Consortium for Policy Research in Education, Teachers College, Columbia University, ***
*** 525 West 120th Street, New York, NY  10027-6696 (kmc2169@columbia.edu). ****
********************************************************************************

use TFA_IncentivePaper_Analysis_SSQFinal.dta, clear
set more off


***************** DESCRIPTIVE STATISTICS *****************
* sawtreatment (=1 if saw incentives treatment)
* complete (=1 if they finished the survey; =0 if they did not finish the survey BUT saw the incentives treatment)
count 
count if sawtreatment == 1
di 1780/14586
count if complete == 1
di 643/14586

*** PERCENT COMPLETE BY TREATMENT ***
* Treatment1 (=1 if Control)
* Treatment2 (=1 if Few Large Prizes (2 $1000)
* Treatment3 (=1 if Many Small Prizes (20 $100)
* Treatment4 (=1 if Few Large and Many Small Prizes
* Treatment 5 (=1 if Charity ($5)
tab complete if treatment1==1
tab complete if treatment2==1
tab complete if treatment3==1
tab complete if treatment4==1
tab complete if treatment5==1

*** PERCENT ANSWERED ONE QUESTION ***
* answerdone (=1 if answered at least one question and saw the incentives treatment; = 0 if didn't answer any questions despite seeing treatment)
tab answeredone if treatment1==1 & sawtreatment==1 
tab answeredone if treatment2==1 & sawtreatment==1 
tab answeredone if treatment3==1 & sawtreatment==1 
tab answeredone if treatment4==1 & sawtreatment==1 
tab answeredone if treatment5==1 & sawtreatment==1 

*** PORTION COMPLETE ***
* percentcomplete (=% of survey questions answered; there were 142 total questions in the survey)
sum percentcomplete if treatment1==1 & sawtreatment !=.
sum percentcomplete if treatment2==1 & sawtreatment !=.
sum percentcomplete if treatment3==1 & sawtreatment !=.
sum percentcomplete if treatment4==1 & sawtreatment !=.
sum percentcomplete if treatment5==1 & sawtreatment !=.

*** PERCENT ATTENTION CHECK CORRECT ***
* Attention Check (=1 if answered the attention check question correctly; = 0 if answered the attention check question incorrectly)

tab attn
tab attn if treatment1==1 & complete==1
tab attn if treatment2==1 & complete==1
tab attn if treatment3==1 & complete==1
tab attn if treatment4==1 & complete==1
tab attn if treatment5==1 & complete==1



***************** ANALYSIS *****************

*** INDIVIDUAL TREATMENTS VERSUS CONTROL ***
reg complete treatment2 treatment3 treatment4 treatment5
reg answeredone2 treatment2 treatment3 treatment4  treatment5 if sawtreatment==1 
reg percentcomplete treatment2 treatment3 treatment4  treatment5 if sawtreatment !=.
reg attn treatment2 treatment3 treatment4 treatment5 if complete==1
set more off

eststo completion: reg complete treatment2 treatment3 treatment4 treatment5
eststo participation: reg answeredone2 treatment2 treatment3 treatment4 treatment5 if  sawtreatment==1
eststo percent: reg percentcomplete treatment2 treatment3 treatment4 treatment5 if  sawtreatment==1
eststo attention: reg attn treatment2 treatment3 treatment4 treatment5 if complete==1
esttab using control2.csv, r(3) b(3) se(3) starlevels(* 0.1 ** 0.05 *** 0.01) label replace 

eststo clear

*** CHARITY VERSUS ALL LOTTERIES (TOGETHER) ***
*Sample without control group
*gen treatment2to5 = .
*replace treatment2to5= 1 if treatment==2 | treatment==3|  treatment==4 | treatment==5 
*replace treatment2to5= 0 if treatment==1

*Charity versus lotteries
reg complete treatment5 if treatment2to5==1
reg answeredone2 treatment5 if treatment2to5==1 & sawtreatment==1 
reg percentcomplete treatment5 if treatment2to5==1 & sawtreatment==1 
reg attn treatment5 if treatment2to5==1 & complete==1

eststo completion: reg complete treatment5 if treatment2to5==1
eststo participation: reg answeredone2 treatment5 if treatment2to5==1 & sawtreatment==1 
eststo percent: reg percentcomplete treatment5 if treatment2to5==1 & sawtreatment==1 
eststo attention: reg attn treatment5 if treatment2to5==1 & complete==1
esttab using charity.csv, r(3) b(3) se(3) starlevels(* 0.1 ** 0.05 *** 0.01) label replace 

eststo clear

*** BIG VERSUS SMALL & BIG+SMALL ***
*gen treatment2to4 = .
*replace treatment2to4= 1 if treatment==2|  treatment==3 | treatment==4
*replace treatment2to4= 0 if treatment==5|  treatment==1
reg complete  treatment3 treatment4  if treatment2to4==1
reg answeredone2  treatment3 treatment4  if treatment2to4==1  &  sawtreatment==1
reg percentcomplete  treatment3 treatment4  if treatment2to4==1  &  sawtreatment==1
reg attn treatment3 treatment4  if treatment2to4==1 & complete==1

eststo complete: reg complete  treatment3 treatment4  if treatment2to4==1
eststo participation: reg answeredone2  treatment3 treatment4  if treatment2to4==1  &  sawtreatment==1
eststo percent: reg percentcomplete  treatment3 treatment4  if treatment2to4==1  &  sawtreatment==1
eststo attention: reg attn treatment3 treatment4  if treatment2to4==1 & complete==1
esttab using lotteryoutput.csv, r(3) b(3) se(3) starlevels(* 0.1 ** 0.05 *** 0.01) label replace 

eststo clear

*** ANALYSIS ON SURVEY LENGTH ***
* surveytimemin = number of minutes spent on survey 
su surveytimemin if complete == 1
su surveytimemin if complete == 1 & surveytimemin < 208
su surveytimemin if complete == 1, de
su surveytimemin if complete == 1 & surveytimemin < 208, de

************************************************
*** LOGISTIC REGRESSION AND MARGINAL EFFECTS ***
************************************************

*******************
*** TABLE B1(a) ***
*******************

eststo complete: logit complete treatment2 treatment3 treatment4 treatment5
eststo answeredone: logit answeredone2 treatment2 treatment3 treatment4 treatment5 if  sawtreatment==1
eststo attention: logit attn treatment2 treatment3 treatment4 treatment5 if complete==1
esttab using logit_control2.csv, r(3) b(3) se(3) starlevels(* 0.1 ** 0.05 *** 0.01) label replace 

eststo clear 

*******************
*** TABLE B1(b) ***
*******************

logit complete treatment2 treatment3 treatment4 treatment5
mfx compute
eststo complete
logit answeredone2 treatment2 treatment3 treatment4 treatment5 if  sawtreatment==1
mfx compute
eststo answeredone
logit attn treatment2 treatment3 treatment4 treatment5 if complete==1
mfx compute
eststo attention
esttab using mfx_control2.csv, r(3) b(3) se(3) starlevels(* 0.1 ** 0.05 *** 0.01) margin label replace 

eststo clear

*******************
*** TABLE B2(a) ***
*******************

eststo complete: logit complete treatment5 if treatment2to5==1
eststo answeredone: logit answeredone2 treatment5 if treatment2to5==1 & sawtreatment==1 
eststo attention: logit attn treatment5 if treatment2to5==1 & complete==1
esttab using logit_charity.csv, r(3) b(3) se(3) starlevels(* 0.1 ** 0.05 *** 0.01) label replace

eststo clear

*******************
*** TABLE B2(b) ***
*******************

logit complete treatment5 if treatment2to5==1
mfx compute
eststo complete
logit answeredone2 treatment5 if treatment2to5==1 & sawtreatment==1 
mfx compute
eststo answerdone
logit attn treatment5 if treatment2to5==1 & complete==1
mfx compute
eststo attention
esttab using mfx_charity.csv, r(3) b(3) se(3) starlevels(* 0.1 ** 0.05 *** 0.01) margin label replace

eststo clear

*******************
*** TABLE B3(a) ***
*******************

eststo complete: logit complete  treatment3 treatment4  if treatment2to4==1
eststo answeredone: logit answeredone2  treatment3 treatment4  if treatment2to4==1  &  sawtreatment==1
eststo attention: logit attn treatment3 treatment4  if treatment2to4==1 & complete==1
esttab using logit_lotteryoutput.csv, r(3) b(3) se(3) starlevels(* 0.1 ** 0.05 *** 0.01) label replace 

eststo clear

*******************
*** TABLE B3(b) ***
*******************

logit complete  treatment3 treatment4  if treatment2to4==1
mfx compute 
eststo complete
logit answeredone2  treatment3 treatment4  if treatment2to4==1  &  sawtreatment==1
mfx compute
eststo answeredone
logit attn treatment3 treatment4  if treatment2to4==1 & complete==1
mfx compute
eststo attention
esttab using mfx_lotteryoutput.csv, r(3) b(3) se(3) starlevels(* 0.1 ** 0.05 *** 0.01) margin label replace 

eststo clear

****************************************
**** BALANCE AND REPRESENTATIVENESS ****
****************************************

*************************************************************
*ARE DISTRIBUTIONS EQUIVALENT? (IN ASSIGNMENT) (TABLE B4(a))
*************************************************************
* Based on Administrative Data
*F-stat and Chi2 tests
* cohort_master = cohort year (2009-2014)
* accepted_master = admission status (=1 if admitted; 0 = not admitted)
* female_master (=1 if female; 0 = male)
foreach var of varlist cohort_master accepted_master female_master ///
    {
	oneway `var' treatment if complete!=.
	}	


**********************************************************************
*BALANCE: ARE DISTRIBUTIONS EQUIVALENT? (FOR COMPLETERS) (TABLE B4(b))
**********************************************************************
* Based on Self-Report (from Survey)
* Cohort = Cohort Year (2009-2014)
* Admit (=1 if Admitted into TFI)
* Hometown Size - Population size of place "where they mostly grew up" (1 = In a village or town (population was less than 5,000); 2= In a small city (population was between 5,000 and 49,999); 3=In a medium-sized city (population was between 50,000 to 499,999); 4=In a large city (population was 500,000 or greater)
* Female (=1 if Female; 0 = Male)
* Marital Status (Married (1); Civil Union (2); Living with another (3); Widowed (4); Separated (5); Divorced (6); Single (7))
* Number of Children (0 (1); 1 (2) 2 (3); 3 (4); 4 or more (5)
* Social Class
* Mother's Education (No formal education (1); Some primary schooling (2); Primary school (3); Upper primary / middle school (4); Secondary school (5); Upper secondary school (6)' Vocational / technical school (7); College / university graduate (Bachelor's degree) (8) m Master's degree (MS, MA, MPhil) (9); Professional degree (MD, JD, MBA, etc.) (10) m Doctoral degree (PhD) (11)
* Hindu (=1 if Hindu; 0 = Not Hindu)

foreach var of varlist cohort admit hometown_size female marital_status nchildren social_class mother_edu hindu ///
    {
	oneway `var' treatment if complete==1
	}


***********************************************
*IS SAMPLE REPRESENTATIVE? (TABLE B4(c))
***********************************************
*COHORT
sum cohort_master
ttest cohort_master==2012.72 if complete!=. 

*ADMIT
sum accepted_master
ttest accepted_master==.3130002 if complete!=. 

*GENDER
sum female_master
ttest female_master==.5625239 if complete!=. 

